; Common state file for M.U.G.E.N beta 2002.04.14
;
; System variables usage
; ----------------------
; Var name    Type   Purpose
; --------    ----   -------
; sysvar(0)   Temp   Set by state 5081 (HITL_SLIDE) to 1 to prevent
;                    showing ground hit frame in state 5110 (HIT_LIEDOWN).
;                    Used by guarding states.
; sysvar(1)   Temp   Used by state 40 (Jump Start) amd 45 (Air Jump Start)
;                    to keep track of which way to jump.
; sysvar(2)   Temp   Used by state 5100 and 5110 to remember downward
;                    velocity of player just before hitting the ground.
;                    Used in state 5080 for storing the anim # to display.

; The following states have special handling within MUGEN, and should be
; overridden with caution:
; Jump Start (40): airjumping bookkeeping at time = 0
;
; All guard states (120-155): guard handling throughout state
; Hit_trip, shaking (5070): defence increases at time = 0
; Hit_bounce (5100): defence increases at time = 0, player becomes
;                    invincible if within 10 ticks of getting up
; Hit_liedown (5110): player changes to get-up state (5120) when ready
; Hit_getup (5120): players defence is restored to normal at time = 0
; Hitfall_recover (5200): players defence is restored at time = 0
; Hitfall_airrecover (5210): players defence is restored at time = 0

;---------------------------------------------------------------------------
; Air Jump
;
; 60 - Down <Impossible to cancel from Attack>
; 70 - Neutral
; 71 - Forward Up
; 72 - Forward Down
; 75 - Back Up <Impossible to cancel from Attack>
; 76 - Back Down <Impossible to cancel from Attack>
; 110 - Forward
; 115 - Back

;---------------------------------------------------------------------------
; Stand
[Statedef 0]
type = S
physics = S
sprpriority = 0

[State 0, 1]
type = ChangeAnim
trigger1 = Anim != 0 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0 ;Turn anim over
value = 0

[State 0, 2]
type = VelSet
trigger1 = Time = 0
y = 0

[State 0, 3] ;Stop moving if low velocity or 4 ticks pass
type = VelSet
trigger1 = abs(vel x) < 2
trigger2 = Time = 4
x = 0

[State 0, 4] ;Are you dead?
type = ChangeState
trigger1 = !alive
value = 5050

[State 0, Kill Helper]
type = DestroySelf
trigger1 = IsHelper = 1

;---------------------------------------------------------------------------
; Stand to Crouch
[Statedef 10]
type    = C
physics = C
anim = 10

[State 10, 1]
type = VelMul
trigger1 = Time = 0
x = .75

[State 10, 2]
type = ChangeState
trigger1 = AnimTime = 0
value = 11

;---------------------------------------------------------------------------
; Crouching
[Statedef 11]
type    = C
physics = C
anim = 11
sprpriority = 0

[State 11, 1] ;Change from turning animation
type = ChangeAnim
trigger1 = Anim = 6 && AnimTime = 0
value = 11

;---------------------------------------------------------------------------
; Crouch to Stand
[Statedef 12]
type    = S
physics = S
anim = 12

[State 12, 1]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; Walk
[Statedef 20]
type    = S
physics = S
sprpriority = 0

[State 20, 1] 
type = ChangeAnim
trigger1 = Anim != 0
value = 0

[State 20, 1] 
type = VelSet 
triggerall = command = "holdfwd" 
trigger1 = var(59) = 0 
trigger2 = p2movetype != H 
trigger3 = helper(27000),var(59) < 4
x = const(velocity.walk.fwd.x) 

[State 20, 2] 
type = VelSet 
triggerall = command = "holdback" 
trigger1 = var(59) = 0 
trigger2 = p2movetype != H 
trigger3 = helper(27000),var(59) < 4
x = const(velocity.walk.back.x) 

[State 20, 1] 
type = VelSet 
triggerall = var(59) > 0 && RoundState = 2 
trigger1 = var(51) = 1
trigger1 = helper(27000),var(59) > 3
x = const(velocity.walk.fwd.x) 

[State 20, 2] 
type = VelSet 
triggerall = var(59) > 0 && RoundState = 2 
trigger1 = var(51) = -1
trigger1 = helper(27000),var(59) > 3
x = const(velocity.walk.back.x) 

[State 20, 3] 
type = VelSet 
triggerall = var(59) > 0 && RoundState = 2 
trigger1 = var(51) = 0
x = 0

[State 20, 5] 
type = ChangeState 
trigger1 = vel X = 0 
value = 0 
ctrl = 1 


;---------------------------------------------------------------------------
; Jump Start(Step)
[Statedef 38]
type    = S
physics = S
ctrl = 0
sprpriority = 1

[State 38, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 38, 2]
type = VarSet
trigger1 = 0
sysvar(1) = 1

[State 38, 3]
type = VarSet
trigger1 = 1
sysvar(1) = -1

[State 38, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 38, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 0
value = 41

[State 38, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 1
value = 42

[State 38, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = -1
value = 43

;---------------------------------------------------------------------------
; Jump Start
[Statedef 39]
type    = S
physics = S
ctrl = 0
sprpriority = 1

[State 39, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 39, 2]
type = VarSet
triggerall = p2movetype = H
trigger1 = p2statetype = A
trigger1 = p2bodydist Y > -70
trigger2 = p2statetype != A
trigger2 = Random < 200
sysvar(1) = 1

[State 39, 3]
type = VarSet
trigger1 = command = "holdback"
trigger1 = p2movetype != H
trigger2 = p2stateno = [120,159]
trigger2 = helper(27000),var(41) = 1
trigger2 = helper(27000),var(59) > 3
trigger3 = p2stateno = [120,159]
trigger3 = helper(27000),var(41) != 1
trigger3 = helper(27000),var(59) > 3
trigger3 = p2statetype != A
sysvar(1) = -1

[State 39, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 39, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 0
value = 41

[State 39, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 1
value = 42

[State 39, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = -1
value = 43

;---------------------------------------------------------------------------
; Jump Start
[Statedef 40]
type    = U
physics = U
ctrl = 0
sprpriority = 1

[State -1, AI]
Type = ChangeState
TriggerAll = Var(59) > 0;ɕK߂悤ɂB
TriggerAll = Statetype = S
Trigger1 = Time = 0
Value = 0
Ctrl = 1
IgnoreHitPause = 1

[State -1, AI]
Type = ChangeState
TriggerAll = Var(59) > 0;ɕK߂悤ɂB
TriggerAll = Statetype = C
Trigger1 = Time = 0
Value = 11
Ctrl = 1
IgnoreHitPause = 1


[State 120, 2]
type = StateTypeSet
trigger1 = Time = 0
physics = S
type = S
pausemovetime = 9999


[State 40, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 40, 2]
type = VarSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 40, 3]
type = VarSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 40, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 40, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 0
value = 41

[State 40, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = 1
value = 42

[State 40, 6]
type = ChangeState
trigger1 = Time = 1
trigger1 = sysvar(1) = -1
value = 43

;---------------------------------------------------------------------------
; Jump Neutral
[Statedef 41]
type = S
physics = S
anim = 41
ctrl = 0
velset = 0,0

[State 41, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 41, VarSet]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 41, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 41, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 41, VelSet]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = 0
y = -7.5

[State 41, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 41, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 41, VarSet]
type = VarSet
trigger1 = AnimElemTime(5) = 0
var(5) = 1

[State 41, VelSet]
type = VelSet
trigger1 = AnimTime = 0
y = 1

[State 41, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 44

[State 41, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Jump Forward
[Statedef 42]
type = S
physics = S
anim = 42
ctrl = 0

[State 42, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(3) = 0
value = s2,0
channel = 4

[State 42, VarSet]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 42, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 42, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(3) = 0
statetype = A
physics = N

[State 42, VelSet]
type = VelSet
trigger1 = AnimElemTime(3) = 0
x = 4.5
y = -7.5

[State 42, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(3) = 1
value = 1

[State 42, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) > 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 42, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) = 0
var(5) = 1

[State 42, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 44

[State 42, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Jump Back
[Statedef 43]
type = S
physics = S
anim = 43
ctrl = 0

[State 43, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 43, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 43, VarSet]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 43, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(3) = 0
statetype = A
physics = N

[State 43, VelSet]
type = VelSet
trigger1 = AnimElemTime(3) = 0
x = -4.5
y = -7.5

[State 43, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(3) = 1
value = 1

[State 43, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) > 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 43, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) = 0
var(5) = 1

[State 43, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 44

[State 43, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Jump Down
[Statedef 44]
type = A
physics = N
anim = 1
ctrl = 1

[State 44, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 1

[State 44, VelSet]
type = VelSet
trigger1 = Time = 0
x = Vel X / 4
y = 1

[State 44, ChangeState]
type = ChangeState
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 44, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump Start
[Statedef 45]
type    = A
physics = N
ctrl = 0
velset = 0,0

[State 45, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(5) = 1

[State 45, 1]
type = ChangeAnim
trigger1 = SelfAnimExist(44)
value = 44

[State 45, 2]
type = ChangeAnim
trigger1 = !SelfAnimExist(44)
value = 41

[State 45, 3]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 45, 4]
type = VarSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 45, 5]
type = VarSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 45, 6]
type = VelSet
trigger1 = Time = 2
x = ifelse(sysvar(1)=0, const(velocity.airjump.neu.x), ifelse(sysvar(1)=1, const(velocity.airjump.fwd.x), const(velocity.airjump.back.x)))
y = const(velocity.airjump.y)

[State 45, 7]
type = ChangeState
trigger1 = Time = 2
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Jump Up
[Statedef 50]
type    = A
physics = A

[State 50, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 50, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

;---------------------------------------------------------------------------
; Jump Down (empty state for compatibility)
[Statedef 51]
type    = A
physics = A

[State 51, 1]
type = Null
trigger1 = 1

;---------------------------------------------------------------------------
; Jump Land
[Statedef 52]
type = S
physics = S
ctrl = 0
anim = 47
facep2 = 1

[State 52, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52, 3]
type = CtrlSet
;trigger1 = Time >= 12
trigger1 = Time = 0
value = 1

[State 52, PlaySnd]
type = Null;PlaySnd
trigger1 = Time = 0
value = s2,1
channel = 3

[State 52, 4]
type = ChangeState
trigger1 = AnimElem = 4
trigger1 = command = "holddown"
value = 11
ctrl = 1

[State 52, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; FALL
[Statedef 53]
type = A
physics = A
anim = 48

[State 53, 2]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Jump Up
[Statedef 54]
type    = A
physics = A

[State 54, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 54, VelSet]
type = VelSet
trigger1 = Time = 0
x = const(velocity.runjump.fwd.x)
y = const(velocity.jump.y)

[State 54, 2]
type = ChangeAnim
trigger1 = Time = 0
value = 41

;---------------------------------------------------------------------------
; FALL
[Statedef 60]
type = A
physics = N
ctrl = 1
anim = 48

[State 60, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 1

[State 60, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.375

[State 60, 2]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump - Fall
[Statedef 61]
type = A
physics = N
anim = 1
ctrl = 1
velset = Vel X/2,1
sprpriority = 1

[State 61, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 1

[State 61, ChangeState]
type = ChangeState
trigger1 = command = "down"
value = 60

[State 61, ChangeState]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; FALL
[Statedef 62]
type = A
physics = N
ctrl = 1
anim = 48

[State 60, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 1

[State 60, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.2

[State 60, 2]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Air Jump - Neutral

[Statedef 70]
type = A
physics = N
anim = 41
ctrl = 0
velset = 0,0

[State 70, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 70, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 70, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 70, VarSet]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 70, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 70, VelSet]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = 0
y = -7.5

[State 70, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 70, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 70, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) = 0
var(5) = 1

[State 70, VelSet]
type = VelSet
trigger1 = AnimTime = 0
y = 1

[State 70, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 44

[State 70, ChangeState]
type = ChangeState
trigger1 = Time > 5
trigger1 = Pos Y >= 0
value = 52

[State 70, 4]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump - Forward - Up
[Statedef 71]
type = A
physics = N
anim = 110
ctrl = 0
velset = 0,0
sprpriority = 1

[State 71, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 71, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 71, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 71, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = 5
y = -7

[State 71, 1]
type = VelAdd
trigger1 = AnimElemTime(4) > 0
y = 0.3

[State 71, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 71, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 71, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 71, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 71, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "a"
var(3) = 400

[State 71, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "b"
var(3) = 410

[State 71, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "c"
var(3) = 420

[State 71, VarSet]
type = Null;VarSet
triggerall = Time >= 8
trigger1 = command = "a"
trigger2 = command = "b"
trigger3 = command = "c"
var(8) = 7

[State 71, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 71, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 71, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 61

[State 71, 4]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump - Forward - Down
[Statedef 72]
type = A
physics = N
anim = 110
ctrl = 0
velset = 0,0
sprpriority = 1

[State 72, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 72, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 72, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 72, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = 5
y = 0

[State 72, 1]
type = VelAdd
trigger1 = AnimElemTime(4) > 0
y = 0.25

[State 72, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 72, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 72, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 72, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 72, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "a"
var(3) = 400

[State 72, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "b"
var(3) = 410

[State 72, VarSet]
type = Null;VarSet
trigger1 = Time >= 8
trigger1 = command = "c"
var(3) = 420

[State 72, VarSet]
type = Null;VarSet
triggerall = Time >= 8
trigger1 = command = "a"
trigger2 = command = "b"
trigger3 = command = "c"
var(8) = 7

[State 72, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 72, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 72, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 61

[State 72, 4]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump - Back - Up
[Statedef 75]
type = A
physics = N
anim = 115
ctrl = 0
velset = 0,0
sprpriority = 1

[State 75, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 75, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 75, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 75, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = -5
y = -7

[State 75, 1]
type = VelAdd
trigger1 = AnimElemTime(4) > 0
y = 0.3

[State 75, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 75, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 75, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 75, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 75, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 75, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 61

[State 75, 4]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; AirJump - Back - Down
[Statedef 76]
type = A
physics = N
anim = 115
ctrl = 0
velset = 0,0
sprpriority = 1

[State 76, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 76, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 76, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 76, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = -5
y = 0

[State 76, 1]
type = VelAdd
trigger1 = AnimElemTime(4) > 0
y = 0.25

[State 76, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(4) = 1
value = 1

[State 76, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 76, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 76, ChangeState]
type = ChangeState
triggerall = AnimElemTime(5) >= 0
trigger1 = command = "down"
trigger2 = var(59) > 0
trigger2 = p2bodydist X != [-100,100]
value = 60

[State 76, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 76, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 61

[State 76, 4]
type = ChangeState
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; RUN_FWD
[Statedef 100]
type = S
physics = S
anim = 100
ctrl = 0
sprpriority = 1

[State 100, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(4) = 0
value = s2,0
channel = 4

[State 100, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = Const(Velocity.run.fwd.x)
y = Const(Velocity.run.fwd.y)

[State 100, 1]
type = VelAdd
trigger1 = AnimElemTime(4) > 0
y = 0.225

[State 100, StateTypeSet]
type = StateTypeSet
trigger1 = AnimElemTime(4) = 0
statetype = A
physics = N

[State 100, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 100, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 100, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 40
PalBright = 0,0,0
PalContrast = 128,128,128
PalAdd = 0,0,0
PalMul = 1,1,1
TimeGap = 2
FrameGap = 2
Trans = Add1
length = 5

[State 100, 4]
type = ChangeState
trigger1 = AnimElemTime(4) > 0
trigger1 = Pos Y >= 0
value = 101

;---------------------------------------------------------------------------
; RUN_FWD_STOP
[Statedef 101]
type = S
physics = S
anim = 101
ctrl = 0
sprpriority = 1

[State 101, PosSet]
type = PosSet
trigger1 = Time = 0
y = 0

[State 101, VelSet]
type = VelSet
trigger1 = Time = [0,10]
x = 10-Time
y = 0

[State 101, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 101, 2]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; RUN_BACK
[Statedef 105]
type = S
physics = S
ctrl = 0
anim = 105
sprpriority = 1

[State 105, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 2

[State 105, PlaySnd]
type = PlaySnd
trigger1 = AnimElemTime(5) = 0
value = s2,0
channel = 4

[State 105, 1]
type = VelSet
trigger1 = AnimElemTime(5) = 0
x = const(velocity.run.back.x)
y = const(velocity.run.back.y)

[State 105, 1]
type = StateTypeSet
trigger1 = AnimElemTime(5) = 0
physics = A
statetype = A
pausemovetime = 9999

[State 105, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 20
PalBright = 0,0,0
PalContrast = 128,128,128
PalAdd = 0,0,0
PalMul = 1,1,1
TimeGap = 2
FrameGap = 1
Trans = Add1
length = 4

[State 105, 3]
type = ChangeState
trigger1 = AnimElemTime(5) >= 0
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 106

;---------------------------------------------------------------------------
; RUN_BACK2 (land)
[Statedef 106]
type = S
physics = S
ctrl = 0
anim = 106

[State 106, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 106, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 106, 3]
type = MakeDust
trigger1 = Time = 2
pos = -5,-2
spacing = 1

[State 106, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; AIRDASH_FWD

[Statedef 110]
type = A
movetype = I
physics = N
ctrl = 0
velset = 0,0
anim = 110

[State 110, PlaySnd]
type = PlaySnd
trigger1 = Time = 0
value = s2,0
channel = 4

[State 110, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 110, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 110, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = 7.25

[State 110, 1]
type = VelAdd
trigger1 = AnimElemTime(4) = 0
y = -1.0

[State 110, 1]
type = VelAdd
trigger1 = AnimElemTime(4) >= 0
y = 0.05

[State 110, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk
flag2 = NoAirGuard

[State 110, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 110, VarSet]
type = VarSet
trigger1 = Time = 0
var(3) = 0

[State 110, VarSet]
type = VarSet
triggerAll = AnimElemTime(2) >= 0
trigger1 = var(59) = 0
trigger1 = command = "a"
trigger2 = var(59) > 0
trigger2 = helper(27000),var(59) <= 2
trigger2 = command = "a"
trigger3 = var(59) > 0
trigger3 = p2movetype != H
trigger3 = command = "a"
var(3) = 400

[State 110, VarSet]
type = VarSet
triggerAll = AnimElemTime(2) >= 0
trigger1 = var(59) = 0
trigger1 = command = "b"
trigger2 = var(59) > 0
trigger2 = helper(27000),var(59) <= 2
trigger2 = command = "b"
trigger3 = var(59) > 0
trigger3 = p2movetype != H
trigger3 = command = "b"
var(3) = 410

[State 110, VarSet]
type = VarSet
triggerAll = AnimElemTime(2) >= 0
trigger1 = var(59) = 0
trigger1 = command = "c"
trigger2 = var(59) > 0
trigger2 = helper(27000),var(59) <= 2
trigger2 = command = "c"
trigger3 = var(59) > 0
trigger3 = p2movetype != H
trigger3 = command = "c"
var(3) = 420

[State 110, ChangeState]
type = ChangeState
trigger1 = AnimElemTime(4) >= 0
trigger1 = command = "down"
value = 60

[State 110, ChangeState]
type = ChangeState
trigger1 = AnimElemTime(5) = 4
trigger1 = var(3) != 0
value = var(3)

[State 110, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(5) = 5
value = 1

[State 110, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 110, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 111

;---------------------------------------------------------------------------
; AIRDASH_FWD_STOP
[Statedef 111]
type = A
physics = N
anim = 1
ctrl = 1
sprpriority = 1
velset = 2,1

[State 111, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 111, 2]
type = ChangeState
trigger1 = var(8) > 0
value = var(3)

[State 111, ChangeState]
type = ChangeState
trigger1 = command = "down"
value = 60

[State 111, 2]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52
ctrl = 1

;---------------------------------------------------------------------------
; AIRDASH_BACK

[Statedef 115]
type = A
movetype = I
physics = N
ctrl = 0
velset = 0,0
anim = 115

[State 115, PlaySnd]
type = PlaySnd
trigger1 = Time = 0
value = s2,0
channel = 4

[State 115, VarSet]
type = VarSet
trigger1 = Time = 0
var(5) = 0

[State 115, VarAdd]
type = VarAdd
trigger1 = Time = 0
var(6) = 1

[State 115, 1]
type = VelSet
trigger1 = AnimElemTime(4) = 0
x = -7.25

[State 115, 1]
type = VelAdd
trigger1 = AnimElemTime(4) = 0
y = -1.0

[State 115, 1]
type = VelAdd
trigger1 = AnimElemTime(4) >= 0
y = 0.05

[State 115, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk
flag2 = NoAirGuard

[State 115, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 115, VarSet]
type = VarSet
trigger1 = Time = 0
var(3) = 0

[State 115, VarSet]
type = VarSet
trigger1 = AnimElemTime(2) >= 0
trigger1 = command = "a"
var(3) = 400

[State 115, VarSet]
type = VarSet
trigger1 = AnimElemTime(2) >= 0
trigger1 = command = "b"
var(3) = 410

[State 115, VarSet]
type = VarSet
trigger1 = AnimElemTime(2) >= 0
trigger1 = command = "c"
var(3) = 420

[State 115, ChangeState]
type = ChangeState
trigger1 = AnimElemTime(4) >= 0
trigger1 = command = "down"
value = 60

[State 115, ChangeState]
type = ChangeState
trigger1 = AnimElemTime(5) = 4
trigger1 = var(3) != 0
value = var(3)

[State 115, CtrlSet]
type = CtrlSet
trigger1 = AnimElemTime(5) = 5
value = 1

[State 115, VarSet]
type = VarSet
trigger1 = AnimElemTime(6) >= 10
var(5) = 1

[State 115, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 116

;---------------------------------------------------------------------------
; AIRDASH_FWD_STOP
[Statedef 116]
type = A
physics = N
anim = 1
ctrl = 1
sprpriority = 1
velset = -2,1

[State 116, AfterImage]
type = AfterImage
trigger1 = Time = 0
time = 0

[State 116, ChangeState]
type = ChangeState
trigger1 = command = "down"
value = 60

[State 116, 2]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52
ctrl = 1

;---------------------------------------------------------------------------
; GUARD (start)
[Statedef 120]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged

[State 120, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 120 + (statetype = C) + (statetype = A)*2
pausemovetime = 9999

[State 120, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S
pausemovetime = 9999

[State 120, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C
pausemovetime = 9999

[State 120, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A
pausemovetime = 9999

[State 120, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C
pausemovetime = 9999

[State 120, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S
pausemovetime = 9999

[State 120, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 130 + (statetype = C) + (statetype = A)*2

[State 120, Stop Guarding]
type = ChangeState
triggerall = StateType = S
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
value = 20
ctrl = 1

[State 120, Stop Guarding]
type = ChangeState
triggerall = StateType = C
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
value = 11
ctrl = 1

[State 120, Stop Guarding]
type = ChangeState
triggerall = StateType = A
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
value = 53
ctrl = 1

;---------------------------------------------------------------------------
; GUARD (start)
[Statedef 125]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged
ctrl = 0
poweradd = 50

[State 125, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 125 + (statetype = C) + (statetype = A)*2
pausemovetime = 9999

[State 125, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S

[State 125, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C

[State 125, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A

[State 125, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C

[State 125, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S

[State 125, Pause]
type = Pause
trigger1 = Time = 0
time = 20
movetime = 20
ignoreHitPause = 1

[State 125, Explod]
type = Explod
triggerall = Time = 0
trigger1 = StateType = S
trigger2 = StateType = A
anim = 10125
postype = p1
pos = 15,-40
facing = 1
bindtime = 1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 3

[State 125, Explod]
type = Explod
trigger1 = Time = 0
trigger1 = StateType = C
anim = 10125
postype = p1
pos = 20,-20
facing = 1
bindtime = 1
removetime = -2
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
sprpriority = 3

[State 125, PlaySnd]
type = PlaySnd
trigger1 = Time = 0
value = s2,2
channel = 4

[State 125, StateTypeSet]
type = StateTypeSet
trigger1 = Time = 0
trigger1 = StateType = A
physics = N

[State 125, StateTypeSet]
type = StateTypeSet
trigger1 = Time = 20
trigger1 = StateType = A
physics = A

[State 125, VarSet];Save Velocity
type = VarSet
trigger1 = Time = 0
trigger1 = StateType = A
fvar(20) = Vel X
ignorehitpause = 1

[State 125, VarSet];Save Velocity
type = VarSet
trigger1 = Time = 0
trigger1 = StateType = A
fvar(21) = Vel Y
ignorehitpause = 1

[State 125, VelSet]
type = VelSet
trigger1 = Time = 1
trigger1 = StateType = A
x = 0
y = 0

[State 125, VelSet]
type = VelSet
trigger1 = Time = 20
trigger1 = StateType = A
x = fvar(20)
y = fvar(21)

[State 125, VarSet]
type = VarSet
trigger1 = Time = 0
var(19) = 0
ignorehitpause = 1

[State 125, VarSet]
type = VarSet
trigger1 = Time = 0
var(18) = 0
ignorehitpause = 1

[State 125, NotHitBy]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 125, 5]
type = ChangeState
trigger1 = Time >= 20
value = 140

;---------------------------------------------------------------------------
; STAND GUARD (guarding)
[Statedef 130]
type    = S
physics = S

[State 130, NotHitBy]
type = Null;NotHitBy
trigger1 = Time = 0
value = , NT,ST,HT
time = 6

[State 130, 1]
type = ChangeAnim
trigger1 = Anim != 130
value = 130

[State 130, Hi to Lo]; 
type = ChangeState
trigger1 = var(59) = 0
trigger1 = command = "holddown"
trigger2 = var(59) > 0
trigger2 = p2statetype != A
value = 131

[State 130, Stop Guarding]
type = ChangeState
trigger1 = !inguarddist
value = 20
ctrl = 1

[State 130, Stop Guarding]
type = ChangeState
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
trigger3 = var(59) > 0
trigger3 = var(55) > 0
trigger3 = Time*(11-helper(27000),var(5))*20 > Random
trigger4 = var(59) > 0
trigger4 = Enemynear,moveguarded
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; CROUCH GUARD (guarding)
[Statedef 131]
type    = C
physics = C

[State 131, NotHitBy]
type = Null;NotHitBy
trigger1 = Time = 0
value = , NT,ST,HT
time = 6

[State 131, 1]
type = ChangeAnim
trigger1 = Anim != 131
value = 131

[State 131, Lo to Hi];
type = ChangeState
trigger1 = var(59) = 0
trigger1 = command != "holddown"
trigger2 = var(59) > 0
trigger2 = p2statetype = A
value = 130

[State 131, Stop Guarding]
type = ChangeState
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
trigger3 = var(59) > 0
trigger3 = var(55) > 0
trigger3 = Time*(11-helper(27000),var(5))*20 > Random
trigger4 = var(59) > 0
trigger4 = Enemynear,moveguarded
value = 11
ctrl = 1

;---------------------------------------------------------------------------
; AIR GUARD (guarding)
[Statedef 132]
type    = A
physics = N

[State 132, NotHitBy]
type = Null;NotHitBy
trigger1 = Time = 0
value = , NT,ST,HT
time = 6

[State 132, 1]
type = ChangeAnim
trigger1 = Anim != 132
value = 132

[State 132, 2]
type = VelAdd
trigger1 = 1
y = Const(movement.yaccel)

[State 132, 3]
type = VarSet
trigger1 = 1
sysvar(0) = (pos y >= 0) && (vel y > 0)

[State 132, 4]
type = VelSet
trigger1 = sysvar(0)
y = 0

[State 132, 5]
type = PosSet
trigger1 = sysvar(0)
y = 0

[State 132, 6]
type = ChangeState
trigger1 = sysvar(0)
trigger1 = command = "holdback" || var(59) > 0
trigger1 = inguarddist
value = 130

[State 132, 7]
type = ChangeState
trigger1 = sysvar(0)
value = 52

[State 132, Stop Guarding]
type = ChangeState
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = !inguarddist
trigger3 = var(59) > 0
trigger3 = var(55) > 0
trigger3 = Time*(11-helper(27000),var(5))*20 > Random
trigger4 = var(59) > 0
trigger4 = Enemynear,moveguarded
value = 53
ctrl = 1

;---------------------------------------------------------------------------
; GUARD (end)
[Statedef 140]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged
ctrl = ifelse(prevstateno = 125,0,1)

[State 140, 1]
type = ChangeAnim
trigger1 = Time = 0
trigger1 = PrevStateNo != 125
value = 140 + (statetype = C) + (statetype = A)*2

[State 140, 1]
type = ChangeAnim
trigger1 = Time = 0
trigger1 = PrevStateNo = 125
value = 145 + (statetype = C) + (statetype = A)*2

[State 140, 1]
type = ChangeState
triggerall = PrevStateNo = 125
trigger1 = var(59) = 0
trigger1 = command != "holdback"
trigger2 = var(18) != 0
trigger3 = var(59) > 0
value = 145

[State 140, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S

[State 140, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C

[State 140, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A

[State 140, Hi to Lo]
type = StateTypeSet
triggerall = statetype = S
trigger1 = var(59) = 0
trigger1 = command = "holddown"
trigger2 = var(59) > 0
trigger2 = p2statetype != A
statetype = C
physics = C

[State 140, Lo to Hi]
type = StateTypeSet
triggerall = statetype = C
trigger1 = var(59) = 0
trigger1 = command != "holddown"
trigger2 = var(59) > 0
trigger2 = p2statetype = A
statetype = S
physics = S

[State 140, 5] ;Implemented within engine
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = !ctrl
trigger1 = StateType = S
value = 0
ctrl = 1

[State 140, 5] ;Implemented within engine
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = !ctrl
trigger1 = StateType = C
value = 11
ctrl = 1

[State 140, 5] ;Implemented within engine
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = !ctrl
trigger1 = StateType = A
value = 53
ctrl = 1

;---------------------------------------------------------------------------
; GUARD (end)
[Statedef 145]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged
ctrl = 0
velset = ifelse(StateType = A,Vel X,0),Vel Y

[State 145, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 145 + (statetype = C) + (statetype = A)*2

[State 145, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S

[State 145, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C

[State 145, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A

[State 145, Hi to Lo]
type = StateTypeSet
trigger1 = statetype = S && command = "holddown"
statetype = C
physics = C

[State 145, Lo to Hi]
type = StateTypeSet
trigger1 = statetype = C && command != "holddown"
statetype = S
physics = S

[State 145, VarSet]
type = VarSet
triggerall = Time = 1
trigger1 = StateType = S
var(14) = 1

[State 145, VarSet]
type = VarSet
triggerall = Time = 3
trigger1 = StateType = C
trigger2 = StateType = A
var(14) = 1

[State 145, ChangeState]
type = ChangeState
triggerall = Time >= 1
triggerall = var(18) != 0
trigger1 = StateType = S
value = var(18)

[State 145, ChangeState]
type = ChangeState
triggerall = Time >= 3
triggerall = var(18) != 0
trigger1 = StateType = C
trigger2 = StateType = A
value = var(18)

[State 145, ChangeState]
type = ChangeState
triggerall = var(18) != 0
trigger1 = AnimTime < 0
trigger1 = command = "holdback"
value = 130 + (StateType = C) + (StateType = A)*2
ctrl = 0

[State 145, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = StateType = S
value = 0
ctrl = 1

[State 145, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = StateType = C
value = 11
ctrl = 1

[State 145, ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
trigger1 = StateType = A
value = 53
ctrl = 1

;---------------------------------------------------------------------------
; SGUARDHIT (shaking)
[Statedef 150]
type    = S
movetype= H
physics = N
velset = 0,0

[State 150, 1]
type = ChangeAnim
trigger1 = 1
value = 150

[State 150, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 151 + 2*(command = "holddown")

[State 150, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C

[State 150, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S

;---------------------------------------------------------------------------
; SGUARDHIT2 (knocked back)
[Statedef 151]
type    = S
movetype= H
physics = S
anim = 150

[State 151, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 151, 2]
type = VelSet
trigger1 = Time = GetHitVar(slidetime)
trigger2 = HitOver
x = 0

[State 151, 3]
type = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value = 1

[State 151, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C

[State 151, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S

[State 151, 4]
type = ChangeState
trigger1 = HitOver
value = 130
ctrl = 1

;---------------------------------------------------------------------------
; CGUARDHIT (shaking)
[Statedef 152]
type    = C
movetype= H
physics = N
velset = 0,0

[State 152, 1]
type = ChangeAnim
trigger1 = 1
value = 151

[State 152, 3]
type = ChangeState
trigger1 = HitShakeOver
value = 151 + 2*(command = "holddown")

[State 152, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C

[State 152, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S

;---------------------------------------------------------------------------
; CGUARDHIT2 (knocked back)
[Statedef 153]
type    = C
movetype= H
physics = C
anim = 151

[State 153, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 153, 2]
type = VelSet
trigger1 = Time = GetHitVar(slidetime)
trigger2 = HitOver
x = 0

[State 153, 3]
type = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value = 1

[State 153, Hi to Lo]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = S && command = "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = S && p2statetype != A
statetype = C
physics = C

[State 153, Lo to Hi]
type = StateTypeSet
trigger1 = var(59) = 0
trigger1 = statetype = C && command != "holddown"
trigger2 = var(59) > 0
trigger2 = statetype = C && p2statetype = A
statetype = S
physics = S

[State 153, 4]
type = ChangeState
trigger1 = HitOver
value = 131
ctrl = 1

;---------------------------------------------------------------------------
; AGUARDHIT (shaking)
[Statedef 154]
type    = A
movetype= H
physics = N
velset = 0,0

[State 154, 1]
type = ChangeAnim
trigger1 = 1
value = 152

[State 154, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 155 ;AGUARDHIT2

[State 154, 3]
type = ForceFeedback
trigger1 = time = 0
waveform = square
time = 4

;---------------------------------------------------------------------------
; AGUARDHIT2 (knocked away)
[Statedef 155]
type    = A
movetype= H
physics = N
anim = 152

[State 155, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 155, 2]
type = VelAdd
trigger1 = 1
y = Const(movement.yaccel)

[State 155, 3]
type = CtrlSet
trigger1 = Time = GetHitVar(ctrltime)
value = 1

[State 155, 4]
type = VarSet
trigger1 = 1
sysvar(0) = (pos y >= 0) && (vel y > 0)

[State 155, 5]
type = VelSet
trigger1 = sysvar(0)
y = 0

[State 155, 6]
type = PosSet
trigger1 = sysvar(0)
y = 0

[State 155, 6]
type = ChangeState
trigger1 = sysvar(0)
trigger1 = command = "holdback" || var(59) > 0
trigger1 = inguarddist
value = 130

[State 155, 7]
type = ChangeState
trigger1 = sysvar(0)
value = 52

;---------------------------------------------------------------------------
; LOSE (Time over)
[Statedef 170]
type = S
ctrl = 0
anim = 170
velset = 0,0

[State 170, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; DRAWGAME (Time over)
[Statedef 175]
type = S
ctrl = 0
velset = 0,0

[State 175, 1] ; If no anim, use go to lose state.
type = ChangeState
trigger1 = Time = 0
trigger1 = !SelfAnimExist(175)
value = 170

[State 175, 2]
type = ChangeAnim
trigger1 = Time = 0
value = 175

[State 175, 3]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; PREINTRO
[Statedef 190]
type = S
ctrl = 0
velset = 0,0

[State 190, 1]
type = ChangeAnim
trigger1 = SelfAnimExist(190)
value = 190

[State 190, 2] ;Go straight to intro.
type = ChangeState
trigger1 = Time = 0
value = 191

;---------------------------------------------------------------------------
; INTRO (override this state to give character an intro)
[Statedef 191]
type = S
ctrl = 0

[State 191, 1]
type = ChangeState
trigger1 = Time = 0
value = 0

;---------------------------------------------------------------------------
; HITG_SHAKE
[Statedef 5000]
type    = S
movetype= H
physics = N
velset = 0,0

[State 5000, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) != [3,5]
value = ifelse((GetHitVar(groundtype) = 1),5000,5010) + GetHitVar(animtype)

[State 5000, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5000, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5000, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5000, 5] ;State type gets set to aerial if getting hit up
type = StateTypeSet
trigger1 = Time = 0
trigger1 = GetHitVar(yvel) != 0 || GetHitVar(fall)
trigger2 = Pos Y != 0
statetype = a

[State 5000, 6]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0 && !GetHitVar(fall)
value = 5001 ;HITG_SLIDE

[State 5000, 7]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5000, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5000, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5000, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITG_SLIDE
[Statedef 5001]
type    = S
movetype= H
physics = S

[State 5001, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5001, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
value = 5005 + GetHitVar(animtype) + (GetHitVar(groundtype)=2)*10

[State 5001, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitVar(slidetime)
x = .6

[State 5001, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5001, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5001, 6]
type = ChangeState
trigger1 = HitOver
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; HITC_SHAKE
[Statedef 5010]
type    = C
movetype= H
physics = N
velset = 0,0

[State 5010, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) != [3,5]
value = 5020 + GetHitVar(animtype)

[State 5010, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5010, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5010, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5010, 5] ;State type gets set to aerial if getting hit up
type = StateTypeSet
triggerall = Time = 0
trigger1 = GetHitVar(yvel) != 0 || GetHitVar(fall)
trigger2 = Pos Y != 0
statetype = a

[State 5010, 6]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0 && !GetHitVar(fall)
value = 5011 ;HITC_SLIDE

[State 5010, 7]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5010, FFB Light]
type = ForceFeedback
trigger1 = anim = 5020
persistent = 0
time = 6
waveform = square

[State 5010, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5021
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5010, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5022
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITC_SLIDE
[Statedef 5011]
type    = C
movetype= H
physics = C

[State 5011, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5011, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
value = 5025 + GetHitVar(animtype)

[State 5011, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitVar(slidetime)
x = .6

[State 5011, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5011, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5011, 6]
type = ChangeState
trigger1 = HitOver
value = 11
ctrl = 1


;---------------------------------------------------------------------------
; HITA_SHAKE
[Statedef 5020]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5020, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) != [3,5]
value = ifelse((GetHitVar(airtype) = 1),5000,5010) + GetHitVar(animtype)

[State 5020, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitVar(animtype) = [3,5]
value = 5030

[State 5020, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitVar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitVar(animtype)))
value = 5047 + GetHitVar(animtype) ;5051 - 4 + type

[State 5020, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5020, 5]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5020, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5020, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5020, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
trigger4 = anim = [5051,5059]
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HITA_UP (initial going up)
[Statedef 5030]
type    = A
movetype= H
physics = N
ctrl = 0

[State 5030, 1]
type = VelAdd;Gravity
trigger1 = 1
y = GetHitVar(yaccel)

[State 5030, 2]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 5030, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5040 ;HITA_RECOV

[State 5030, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5050 ;HITA_FALL

[State 5030, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 5035 ;HITA_UP (transition)

;---------------------------------------------------------------------------
; HITA_UP_T (transition)
[Statedef 5035]
type    = A
movetype= H
physics = N

[State 5035, 1]
type = ChangeAnim
trigger1 = Time = 0
trigger1 = SelfAnimExist(5035)
trigger1 = Anim != [5051,5059] ;Not if in hit up anim
trigger1 = Anim != 5090 ;Not if hit off ground anim
value = 5035

[State 5035, 2]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5035, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = AnimTime = 0 ;Animation over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = Time = 0     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5040 ;HITA_RECOV

[State 5035, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = AnimTime = 0 ;Anim is over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = Time = 0     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5050 ;HITA_FALL

;---------------------------------------------------------------------------
; HITA_RECOV (recovering in air, not falling)
[Statedef 5040]
type    = A
movetype= H
physics = N

[State 5040, 1]
type = ChangeState
trigger1 = !Alive
value = 5050

[State 5040, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim != 5040
trigger2 = Time = 0
trigger2 = Anim != 5035
value = 5040

[State 5040, 3]
type = CtrlSet
trigger1 = HitOver
value = 1

[State 5040, 4]
type = StateTypeSet
trigger1 = HitOver
movetype = I

[State 5040, 5]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5040, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMPLAND

;---------------------------------------------------------------------------
; HITA_FALL (knocked up, falling)
[Statedef 5050]
type    = A
movetype= H
physics = N

[State 5050, 1] ;Change anim when done with transition
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim = 5035
trigger2 = Time = 0     ;If no transition anim
trigger2 = Anim != 5035
trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
trigger2 = Anim != 5090 ;Not if hit off ground anim
value = 5050

[State 5050, 2] ;Coming down anim
type = ChangeAnim
trigger1 = anim = [5050,5059]
trigger1 = Vel Y >= ifelse(anim = 5050, 1, -2)
trigger1 = SelfAnimExist(anim+10)
value = anim+10
persistent = 0

[State 5050, 3] ;Gravity
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5050, 4] ;Recover near ground
type = Null;ChangeState
triggerall = Vel Y > 0
triggerall = Pos Y >= -20
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5200 ;HITFALL_RECOVER

[State 5050, 5]; Recover in mid air
type = ChangeState
triggerall = Vel Y > -1
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5210 ;HITFALL_AIRRECOVER

[State 5050, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= ifelse((anim = [5051,5059]) || (anim = [5061,5069]), 0, 25)
value = 5100 ;HIT_BOUNCE

;---------------------------------------------------------------------------
; HIT_TRIP (shaking)
[Statedef 5070]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5070, 1]
type = ChangeAnim 
trigger1 = 1
value = 5070

[State 5070, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 5071

[State 5070, 3]
type = ForceFeedback
trigger1 = time = 0
time = 12
waveform = sinesquare
ampl = 140

;---------------------------------------------------------------------------
; HIT_TRIP2 (fall through air)
[Statedef 5071]
type    = A
movetype= H
physics = N

[State 5071, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 5071, 2] ;Acceleration
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5071, 3] ;Hit ground
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 15
type = ChangeState
value = 5110

;---------------------------------------------------------------------------
; HITL_SHAKE
[Statedef 5080]
type    = L
movetype= H
physics = N
velset = 0,0

[State 5080, 1] ;Set default anim
type = VarSet
trigger1 = time = 0
sysvar(2) = ifelse (GetHitVar(yvel) = 0, 5080, 5090)

[State 5080, 2]
type = VarAdd
trigger1 = time = 0
trigger1 = (anim = [5081,5089]) || (anim = [5111,5119])
trigger1 = SelfAnimExist(sysvar(2) + (anim % 10))
sysvar(2) = anim % 10

[State 5080, 3] ;If 5090 doesn't exist, default to 5030'
type = VarSet
trigger1 = time = 0
trigger1 = sysvar(2) = 5090
trigger1 = !SelfAnimExist(5090)
sysvar(2) = 5030

[State 5080, 3] ;Freeze
type = ChangeAnim
trigger1 = 1
value = sysvar(2)

[State 5080, 4]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) = 0
value = 5081 ;HITL_SLIDE

[State 5080, 5]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitVar(yvel) != 0
value = 5030 ;HITA_UP

;---------------------------------------------------------------------------
; HITL_SLIDE
[Statedef 5081]
type    = L
movetype= H
physics = C

[State 5081, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5081, 2]
type = VelSet
trigger1 = HitOver
x = 0

[State 5081, 3] ;Don't show hit ground frame'
type = VarSet
trigger1 = Time = 0
sysvar(0) = 1

[State 5081, 4]
type = ChangeState
trigger1 = HitOver
value = 5110 ;HIT_LIEDOWN

;---------------------------------------------------------------------------
; HIT_BOUNCE (hit ground)
[Statedef 5100]
type    = L
movetype= H
physics = N

[State 5100, 1]
type = VelSet
trigger1 = Time = 0
trigger1 = GetHitVar(fall.yvel) = 0
trigger1 = vel x > 1
x = 1

[State 5100, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5100, Var] ;Save fall velocity
type = VarSet
trigger1 = Time = 0
sysvar(1) = floor(vel y)

[State 5100, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = (anim != [5051,5059]) && (anim != [5061,5069])
trigger2 = !SelfAnimExist(5100 + (anim % 10))
value = 5100

[State 5100, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
trigger1 = time = 0
trigger1 = (anim = [5051,5059]) || (anim = [5061,5069])
trigger1 = SelfAnimExist(5100 + (anim % 10))
value = 5100 + (anim % 10)

[State 5100, 4]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5100, 5]
type = VelSet
trigger1 = Time = 0
y = 0

[State 5100, 6] ;Reduce speed
type = VelMul
trigger1 = Time = 0
x = 0.75

[State 5100, 7]
type = ChangeState
trigger1 = Time = 0
trigger1 = GetHitVar(fall.yvel) = 0
value = 5110 ;HIT_LIEDOWN

[State 5100, 8]
type = Null;GameMakeAnim
trigger1 = Time = 1
value = 60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 14

[State 5100, 9]
type = HitFallDamage
trigger1 = Time = 0

[State 5100, 10]
type = Null;PlaySnd
trigger1 = Time = 1
;value = F7, (sysvar(1) > 5) + (sysvar(1) > 14)
value = s2,8

[State 5100, 11]
type = PosFreeze
trigger1 = 1

[State 5100, 12]
type = ChangeState
trigger1 = Time = 0
value = 5101

[State 5100, 13]
type = ForceFeedback
trigger1 = Time = 0
waveform = sinesquare
ampl = 128,-3,-.2,.005
time = 20

;---------------------------------------------------------------------------
; HIT_BOUNCE (bounce into air)
[Statedef 5101]
type    = L
movetype= H
physics = N

[State 5101, 1] ;Coming hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim != [5101,5109]
trigger2 = !SelfAnimExist(5160 + (anim % 10))
value = 5160

[State 5101, 2] ;Coming hit ground anim (for hit up)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim = [5101,5109]
trigger1 = SelfAnimExist(5160 + (anim % 10))
value = 5160 + (anim % 10)

[State 5101, 3]
type = HitFallVel
trigger1 = Time = 0

[State 5101, 4]
type = Null;PosSet
trigger1 = Time = 0
y = 20

[State 5101, 5] ;Acceleration
type = Null;VelAdd
trigger1 = 1
y = .4

[State 5101, 6] ;Hit ground
type = ChangeState
trigger1 = Time = 0
;trigger1 = Vel Y > 0
;trigger1 = Pos Y >= 12
value = 5110

;---------------------------------------------------------------------------
; HIT_LIEDOWN
[Statedef 5110]
type    = L
movetype= H
physics = N

[State 5110, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5110, 1] ;For hit up/up-diag type (from state 5081)
type = ChangeAnim
persistent = 0
trigger1 = SelfAnimExist(5110 + (anim % 10))
trigger1 = anim = [5081,5089]
value = 5110 + (anim % 10)

[State 5110, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim != [5161,5169]
trigger2 = !SelfAnimExist(5170 + (anim % 10))
value = 5170

[State 5110, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim = [5161,5169]
trigger1 = SelfAnimExist(5170 + (anim % 10))
value = 5170 + (anim % 10)

[State 5110, 4]
type = HitFallDamage
trigger1 = Time = 0

[State 5110, 5]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5110, Var] ;Get fall velocity
type = VarSet
trigger1 = Time = 0
trigger1 = GetHitVar(fall.yvel) != 0
sysvar(1) = floor(vel y)

[State 5110, 6]
type = PlaySnd
trigger1 = Time = 0
;trigger1 = !SysVar(0)
;value = F7, (sysvar(1) > 5) + (sysvar(1) > 14)
value = s2,4

[State 5110, 7]
type = Null;GameMakeAnim
trigger1 = Time = 0
trigger1 = !SysVar(0)
value = 60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 14

[State 5110, 8]
type = VelSet
trigger1 = Time = 0
x = 0
y = 0

[State 5110, 9] ;For hit up type
type = ChangeAnim
persistent = 0
triggerall = anim = [5171,5179]
triggerall = SelfAnimExist(5110 + (anim % 10))
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground anim
value = 5110 + (anim % 10)

[State 5110, 10] ;For normal
type = ChangeAnim
persistent = 0
triggerall = Anim != [5111,5119]
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
value = 5110

[State 5110, 11] ;If just died
type = ChangeState
triggerall = !alive
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
trigger3 = Anim = [5110,5119]
value = 5150

[State 5110, 12]
type = VarSet
trigger1 = SysVar(0)
trigger1 = Time = 0
sysvar(0) = 0

[State 5110, 13] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5110, 14]
type = ForceFeedback
trigger1 = alive
trigger1 = Time = 0
time = 8
ampl = 240
waveform = sine

[State 5110, 15]
type = ForceFeedback
trigger1 = !alive
trigger1 = Time = 0
ampl = 200, 7, -.467
time = 30
waveform = sine

[State 5110, Effect]
type = Explod
trigger1 = Time = 0
anim = 15110
postype = p1
pos = -10,0
facing = 1
bindtime = 1
removetime = -2
ownpal = 1
supermovetime = 0
pausemovetime = 0
sprpriority = 3

[State 5110, EnvShake]
type = EnvShake
trigger1 = Time = 0
trigger1 = !SysVar(0)
trigger1 = PrevStateNo != 5081
time = 10
freq = 80
ampl = 4

;---------------------------------------------------------------------------
; HIT_GETUP
[Statedef 5120]
type    = L
movetype= I
physics = N

[State 5120, 1a] ;Get up anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim != [5111,5119]
trigger2 = !SelfAnimExist(5120 + (anim % 10))
value = 5120

[State 5120, 1b] ;Get up anim (for hit up/diag-up)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim = [5111,5119]
trigger1 = SelfAnimExist(5120 + (anim % 10))
value = 5120 + (anim % 10)

[State 5120, 2]
type = VelSet
trigger1 = Time = 0
x = 0

[State 5120, 3]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5120, 4]
type = HitFallSet
trigger1 = AnimTime = 0
value = 1

[State 5120, 5] ;Can't be thrown right after getting up
type = NotHitBy
trigger1 = AnimTime = 0
value = , NT,ST,HT
time = 12

[State 5120, 6] ;Can't be hit right after getting up (short time)
type = NotHitBy
trigger1 = AnimTime = 0
value2 = SCA
time = 3

[State 5120, 7]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; HIT_LIEDEAD
[Statedef 5150]
type    = L
movetype= H
physics = N
sprpriority = 3

[State 5150, 1] ;Normal anim
type = ChangeAnim
triggerall = Time = 0
triggerall = SelfAnimExist(5140)
trigger1 = (anim != [5111,5119]) && (anim != [5171,5179])
trigger2 = !SelfAnimExist(5140 + (anim % 10))
value = 5140

[State 5150, 3] ;Hit up type anim
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (anim = [5111,5119]) || (anim = [5171,5179])
trigger1 = SelfAnimExist(5140 + (anim % 10))
value = 5140 + (anim % 10)

[State 5150, 4] ;Match over anim
type = ChangeAnim
persistent = 0
;trigger1 = Time = 0
trigger1 = MatchOver = 1
trigger1 = Anim = [5140,5149]
trigger1 = SelfAnimExist(anim+10)
value = anim+10

[State 5150, 5] ;Switch to 5110 if liedead anim does not exist
type = ChangeAnim
trigger1 = Time = 0
trigger1 = Anim != [5140,5159]
trigger1 = Anim != [5110,5119]
value = 5110

[State 5150, 6] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
type = VelSet
trigger1 = Vel x < .05
persistent = 0
x = 0

[State 5150, 8]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; HIT_FALLRECOVER (still falling)
[Statedef 5200]
type    = A
movetype= H
physics = N

[State 5200, 1] ;Change anim if done with transition
type = ChangeAnim
trigger1 = Anim = 5035
trigger1 = AnimTime = 0
value = 5050

[State 5200, 2]
type = VelAdd
trigger1 = 1
y = GetHitVar(yaccel)

[State 5200, 3]
type = SelfState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 10
value = 5201

;---------------------------------------------------------------------------
; HIT_FALLRECOVER (on the ground)
[Statedef 5201]
type    = A
movetype= H
physics = A
anim = 5200

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201, 2]
type = VelSet
trigger1 = Time = 0
x = -.15
y = -3.5

[State 5201, 3]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5201, 5] ;Blink white
type = PalFX
trigger1 = Time = 0
time = 3
add = 128,128,128 ;256,256,256

[State 5201, 6]
type = GameMakeAnim
trigger1 = Time = 1
value = 60
pos = 0, 0
under = 1

;---------------------------------------------------------------------------
; HIT_AIRFALLRECOVER
[Statedef 5210]
type    = A
movetype= I
physics = N
anim = 5210
ctrl = 0

[State 5210, 1] ;Blink white
type = PalFX
trigger1 = Time = 0
time = 3
add = 128,128,128 ;256,256,256

[State 5210, 1]
type = PosFreeze
trigger1 = Time = 0
value = 4

[State 5210, 2] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -20

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
x = .8
y = .8

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
y = -4.5

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
trigger1 = Vel Y > 0
y = .5

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -3
y = -2

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -2
y = -1

[State 5210, 2] ;Go up
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holdup"
y = -2

[State 5210, 2] ;Go down
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holddown"
y = 1.5

[State 5210, 2] ;Go fwd
type = VelMul
trigger1 = Time = 4
trigger1 = Command = "holdfwd"
x = 1

[State 5210, 2] ;Go back
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holdback"
x = -1

[State 5210, 3]
type = NotHitBy
trigger1 = Time = 0
value = SCA
time = 15

[State 5210, 4]
type = CtrlSet
trigger1 = Time = 20
value = 1

[State 5210, 5]
type = VelAdd;Gravity
trigger1 = Time >= 4
y = .35

[State 5210, 5] ;Land on ground
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMP_LAND
ctrl = 1

;---------------------------------------------------------------------------
; Continue?
[Statedef 5500]
type = S
ctrl = 0
anim = 5300
velset = 0,0

[State 5500, 1] ;Use continue animation if available
type = ChangeAnim
trigger1 = time = 0
trigger1 = SelfAnimExist(5500)
value = 5500

;---------------------------------------------------------------------------
; Initialize (at the start of the round)
[Statedef 5900]
type = S

[State 5900, 1] ;Clear all int variables
type = VarRangeSet
trigger1 = roundsexisted = 0
value = 0
persistent = 0

[State 5900, 2] ;Clear all float variables
type = VarRangeSet
trigger1 = roundsexisted = 0
fvalue = 0
persistent = 0

[State 5900, 4]
type = Helper
trigger1 = Time = 0
name = "System"
ID = 50000
stateno = 50000
pos = 0,0
postype = p1
sprpriority = -7
supermovetime = 9999

[State 5900, 5]
type = Null;Helper
trigger1 = RoundsExisted = 0
trigger1 = Time = 0
name = "Mode_Select"
ID = 50010
stateno = 50010
pos = 0,-40
postype = p1
sprpriority = 7
ownpal = 1
supermovetime = 9999
pausemovetime = 9999
persistent = 0

[State 5900, 3] ;Intro for round 1
type = ChangeState
trigger1 = roundno = 1
value = 190

